/*
** Poly-marker shapes
*/

# define DOT		1
# define PLUS		2
# define STAR		3
# define SQUARE		4
# define CROSS		5
# define DIAMOND	6

/*
** Poly-line line types
*/

# define SOLID			1
# define L0NGDASH		2
# define DOTTED			3
# define DASHDOT		4
# define DASH			5
# define DASHDOTDOT		6

/*
** Poly-line end styles
*/

# define SQUARE			0
# define ARROW			1
# define ROUNDED		2

line_chart( vw, count, data )
int vw, count;
double *data; {
	
	double max_x, max y, min_x, min_y, x, y;
	int i, points[512], off;
	extern int box_x, box_y, box_w, box_h;
	
	count /= 2;
	if( count < 3 ){
		show_form("No data after increments and corners");
		return;
		}
	x = *data++;
	y = *data++;
	count--;
	range( count, data, &max_x, &max_y, &min_x, &min_y );
	off = grid( vw, x, y, max_x, max_y, min_x, min_y );
	data += 4;		/* skip corner data */
	count -= 2;
	for( i = 0; i < count * 2; i += 2 ){
	points[i] = box_x +
			scale(data[i],max_x,min_x,box_w-off) + off;
	points[i+1] = box_y + box_h -
			scale(data[i+1],max_y,min_y,box_h);
	}
	vsl_type(vw, SOLID );				/* solid lines */
# ifdef THIN_LINES
	vsm.type( vw, DIAMOND ); 			/* diamonds at vertices */
	v_pmarker( vw, count, points );		/* draw the diamonds */
	vsl_width( vw, 1); 					/* draw thin lines */
# else
	vsl_width( vw, 8); 					/* draw wide lines */
	vsl_ends( vw, ROUNDED, ARROW );		/* with fancy ends */
# endif THIN_LINES
	v_pline( vw, count, points );		/* draw the lines */
}